/*******************************************************************************
 ap_dump.h - Apache debug dump functions

 Copyright (C) 2020-2025 CodeShop B.V.
 http://www.code-shop.com

 For licensing see the LICENSE file
******************************************************************************/

#ifndef AP_DUMP_H_AKW
#define AP_DUMP_H_AKW

#ifdef __cplusplus
extern "C" {
#endif

typedef struct apr_pool_t apr_pool_t;
typedef struct apr_table_t apr_table_t;
typedef struct apr_uri_t apr_uri_t;
typedef struct request_rec request_rec;
typedef struct server_rec server_rec;

char* dump_apr_table_t(apr_pool_t* pool, apr_table_t const* t);
char* dump_apr_uri_t(apr_pool_t* pool, apr_uri_t const* u);
char* dump_request_rec(apr_pool_t* pool, request_rec const* r);
char* dump_server_rec(apr_pool_t* pool, server_rec const* r);

#ifdef __cplusplus
} // extern C
#endif

#endif // AP_DUMP_H_AKW

// End Of File

