# SYNOPSIS
#
#   AX_LIB_FMP4([MINIMUM-VERSION])
#
# DESCRIPTION
#
#   Test for the fmp4 library
#
#   This macro takes only one optional argument, required version of the
#   library.
#
#   If no intallation prefix to the installed library is given the macro
#   searches under /usr/local, /usr and /opt.
#
#   This macro calls:
#
#     AC_SUBST(FMP4_CFLAGS)
#     AC_SUBST(FMP4_LDFLAGS)
#
#   And sets:
#
#     HAVE_FMP4

AC_DEFUN([AX_LIB_FMP4],
[
    AC_ARG_WITH([fmp4],
        AS_HELP_STRING(
            [--with-fmp4=@<:@ARG@:>@],
            [use fmp4 library @<:@default=yes@:>@, optionally specify the prefix for fmp4 library]
        ),
        [
        if test "$withval" = "no"; then
            WANT_FMP4="no"
        elif test "$withval" = "yes"; then
            WANT_FMP4="yes"
            ac_fmp4_path=""
        else
            WANT_FMP4="yes"
            ac_fmp4_path="$withval"
        fi
        ],
        [WANT_FMP4="yes"]
    )

    FMP4_CFLAGS=""
    FMP4_LDFLAGS=""

    if test "x$WANT_FMP4" = "xyes"; then

        ac_fmp4_header="mod_streaming_export.h"

        fmp4_version_req=ifelse([$1], [], [1.4.5], [$1])
        fmp4_version_req_major=`expr $fmp4_version_req : '\([[0-9]]*\)'`
        fmp4_version_req_minor=`expr $fmp4_version_req : '[[0-9]]*\.\([[0-9]]*\)'`
        fmp4_version_req_revision=`expr $fmp4_version_req : '[[0-9]]*\.[[0-9]]*\.\([[0-9]]*\)'`

        AC_MSG_CHECKING([for fmp4 library >= $fmp4_version_req])

        if test "$ac_fmp4_path" != ""; then
            ac_fmp4_ldflags="-L$ac_fmp4_path/lib"
            ac_fmp4_cflags="-I$ac_fmp4_path/include/fmp4"
        else
            for ac_fmp4_path_tmp in /usr/local /usr /opt ; do
                if test -r "$ac_fmp4_path_tmp/include/fmp4/$ac_fmp4_header"; then
                    ac_fmp4_path=$ac_fmp4_path_tmp
                    ac_fmp4_cflags="-I$ac_fmp4_path_tmp/include/fmp4"
                    ac_fmp4_ldflags="-L$ac_fmp4_path_tmp/lib"
                    break;
                fi
            done
        fi

        ac_fmp4_ldflags="$ac_fmp4_ldflags -lfmp4"

        saved_CFLAGS="$CFLAGS"
        CFLAGS="$CFLAGS $ac_fmp4_cflags"

        AC_LANG_PUSH(C)
        AC_COMPILE_IFELSE(
            [
            AC_LANG_PROGRAM([[@%:@include <mod_streaming_export.h>]],
                [[
#if (MOD_SMOOTH_STREAMING_VERSION_MAJOR == $fmp4_version_req_major) && \
    (MOD_SMOOTH_STREAMING_VERSION_MINOR == $fmp4_version_req_minor) && \
    (MOD_SMOOTH_STREAMING_VERSION_REVISION >= $fmp4_version_req_revision)
// Everything is okay
#else
#  error libfmp4 version does not match
#endif
                ]]
            )
            ],
            [
            AC_MSG_RESULT([yes])
            success="yes"
            ],
            [
            AC_MSG_RESULT([not found])
            success="no"
            ]
        )
        AC_LANG_POP([C])

        CFLAGS="$saved_CFLAGS"

        if test "$success" = "yes"; then

          saved_LDFLAGS="$LDFLAGS"
          LDFLAGS="$LDFLAGS $ac_fmp4_ldflags"
          AC_CHECK_LIB(fmp4,create_post_handler,
            [ac_fmp4_cflags="$ac_fmp4_cflags -DHAVE_FMP4_LIVE"],
            AC_MSG_NOTICE([*** fmp4 library without LIVE support ***])
          )
          LDFLAGS="$saved_LDFLAGS"

          FMP4_CFLAGS="$ac_fmp4_cflags"
          FMP4_LDFLAGS="$ac_fmp4_ldflags"

          AC_SUBST(FMP4_CFLAGS)
          AC_SUBST(FMP4_LDFLAGS)
          AC_DEFINE([HAVE_FMP4], [], [Have the FMP4 library])
      fi
    fi
])
