# SYNOPSIS
#
#   AX_LIB_REMIX([MINIMUM-VERSION])
#
# DESCRIPTION
#
#   Test for the remix library
#
#   This macro takes only one optional argument, required version of the
#   library.
#
#   If no intallation prefix to the installed library is given the macro
#   searches under /usr/local, /usr and /opt.
#
#   This macro calls:
#
#     AC_SUBST(REMIX_CFLAGS)
#     AC_SUBST(REMIX_LDFLAGS)
#
#   And sets:
#
#     HAVE_REMIX

AC_DEFUN([AX_LIB_REMIX],
[
    AC_ARG_WITH([remix],
        AS_HELP_STRING(
            [--with-remix=@<:@ARG@:>@],
            [use remix library @<:@default=yes@:>@, optionally specify the prefix for remix library]
        ),
        [
        if test "$withval" = "no"; then
            WANT_REMIX="no"
        elif test "$withval" = "yes"; then
            WANT_REMIX="yes"
            ac_remix_path=""
        else
            WANT_REMIX="yes"
            ac_remix_path="$withval"
        fi
        ],
        [WANT_REMIX="yes"]
    )

    REMIX_CFLAGS=""
    REMIX_LDFLAGS=""

    if test "x$WANT_REMIX" = "xyes"; then

        ac_remix_header="unified_remix_export.h"

        AC_MSG_CHECKING([for remix library])

        if test "$ac_remix_path" != ""; then
            ac_remix_ldflags="-L$ac_remix_path/lib"
            ac_remix_cflags="-I$ac_remix_path/include/remix"
        else
            for ac_remix_path_tmp in /usr/local /usr /opt ; do
                if test -r "$ac_remix_path_tmp/include/remix/$ac_remix_header"; then
                    ac_remix_path=$ac_remix_path_tmp
                    ac_remix_cflags="-I$ac_remix_path_tmp/include/remix"
                    ac_remix_ldflags="-L$ac_remix_path_tmp/lib"
                    break;
                fi
            done
        fi

        # TODO: check if we actually found $ac_remix_header.
        AC_MSG_RESULT([yes])

        ac_remix_ldflags="$ac_remix_ldflags -lremix"

        REMIX_CFLAGS="$ac_remix_cflags"
        REMIX_LDFLAGS="$ac_remix_ldflags"

        AC_SUBST(REMIX_CFLAGS)
        AC_SUBST(REMIX_LDFLAGS)
        AC_DEFINE([HAVE_REMIX], [], [Have the REMIX library])
    fi
])
