/*******************************************************************************
 ap_log.h - Apache logging macros

 Copyright (C) 2020-2026 CodeShop B.V.
 http://www.code-shop.com

 For licensing see the LICENSE file
******************************************************************************/

#ifndef AP_LOG_H_AKW
#define AP_LOG_H_AKW

#include <apr.h>
#include <http_log.h>

#ifdef __cplusplus
extern "C" {
#endif

#if defined(APLOG_USE_MODULE) && defined(MODULE_NAME)
#define INVOKE_APLOG_USE_MODULE(n) APLOG_USE_MODULE(n)
INVOKE_APLOG_USE_MODULE(MODULE_NAME);
#endif

#define APLOG_P(l, p, ...) \
  do \
  { \
    ap_log_perror(APLOG_MARK, (l), APR_SUCCESS, (p), "USP: " __VA_ARGS__); \
  } \
  while(0)

#define APLOG_R(l, r, ...) \
  do \
  { \
    ap_log_rerror(APLOG_MARK, (l), APR_SUCCESS, (r), "USP: " __VA_ARGS__); \
  } \
  while(0)

#define APLOG_S(l, s, ...) \
  do \
  { \
    ap_log_error(APLOG_MARK, (l), APR_SUCCESS, (s), "USP: " __VA_ARGS__); \
  } \
  while(0)

#ifndef APLOG_TRACE1
#define APLOG_TRACE1 APLOG_DEBUG
#endif
#ifndef APLOG_TRACE3
#define APLOG_TRACE3 APLOG_DEBUG
#endif

#define TRACE1_P(p, ...)  APLOG_P(APLOG_TRACE1,  p, __VA_ARGS__)
#define TRACE1_R(r, ...)  APLOG_R(APLOG_TRACE1,  r, __VA_ARGS__)
#define TRACE1_S(s, ...)  APLOG_S(APLOG_TRACE1,  s, __VA_ARGS__)
#define TRACE3_P(p, ...)  APLOG_P(APLOG_TRACE3,  p, __VA_ARGS__)
#define TRACE3_R(r, ...)  APLOG_R(APLOG_TRACE3,  r, __VA_ARGS__)
#define TRACE3_S(s, ...)  APLOG_S(APLOG_TRACE3,  s, __VA_ARGS__)
#define DEBUG_P(p, ...)   APLOG_P(APLOG_DEBUG,   p, __VA_ARGS__)
#define DEBUG_R(r, ...)   APLOG_R(APLOG_DEBUG,   r, __VA_ARGS__)
#define DEBUG_S(s, ...)   APLOG_S(APLOG_DEBUG,   s, __VA_ARGS__)
#define WARNING_P(p, ...) APLOG_P(APLOG_WARNING, p, __VA_ARGS__)
#define WARNING_R(r, ...) APLOG_R(APLOG_WARNING, r, __VA_ARGS__)
#define WARNING_S(s, ...) APLOG_S(APLOG_WARNING, s, __VA_ARGS__)
#define ERROR_P(p, ...)   APLOG_P(APLOG_ERR,     p, __VA_ARGS__)
#define ERROR_R(r, ...)   APLOG_R(APLOG_ERR,     r, __VA_ARGS__)
#define ERROR_S(s, ...)   APLOG_S(APLOG_ERR,     s, __VA_ARGS__)

#ifndef APR_INT64_T_FMT
#define APR_INT64_T_FMT PRId64
#endif

#ifndef APR_UINT64_T_FMT
#define APR_UINT64_T_FMT PRIu64
#endif

#ifndef APR_UINT64_T_HEX_FMT
#define APR_UINT64_T_HEX_FMT PRIx64
#endif

#ifdef __cplusplus
} // extern C
#endif

#endif // AP_LOG_H_AKW

// End Of File

