/*******************************************************************************
 log_util.cpp - Apache logging utilities

 Copyright (C) 2025-2026 CodeShop B.V.
 http://www.code-shop.com

 For licensing see the LICENSE file
******************************************************************************/

#include <httpd.h>
#include <http_log.h>

#include <log_util.h>

fmp4_log_level_t apache_log_level_to_fmp4_log_level(int level)
{
  if(level >= APLOG_TRACE1)
  {
    return FMP4_LOG_TRACE;
  }
  if(level >= APLOG_DEBUG)
  {
    return FMP4_LOG_DEBUG;
  }
  if(level >= APLOG_INFO)
  {
    return FMP4_LOG_INFO;
  }
  if(level >= APLOG_WARNING)
  {
    return FMP4_LOG_WARNING;
  }

  return FMP4_LOG_ERROR;
}

int fmp4_log_level_to_apache_log_level(fmp4_log_level_t level)
{
  switch(level)
  {
  case FMP4_LOG_TRACE:
    return APLOG_TRACE1;
  case FMP4_LOG_DEBUG:
    return APLOG_DEBUG;
  case FMP4_LOG_INFO:
    return APLOG_INFO;
  case FMP4_LOG_WARNING:
    return APLOG_WARNING;
  case FMP4_LOG_ERROR:
  default:
    return APLOG_ERR;
  }
}

// End Of File
